# Action Pack for Groups, Users, Teams with Microsoft Graph
Use cases for managing teams with Microsoft Graph
> Note: The use of the scripts requires the Modules Microsoft.Graph.Groups, Microsoft.Graph.Teams, Microsoft.Graph.Users, Microsoft.Graph.Authentication, Microsoft.Graph.Identity.DirectoryManagement.

## [Authentication](./Authentication)

+ Add, get, set, remove environment
+ Get context
+ Get, set Graph option
+ Get, set Graph request context
+ Invoke Graph request
+ Find Graph permission, Graph command

## [Contacts](./Contacts)

+ Get contact manager, direct report, member group, member object, member of, transitive member of
+ Confirm member of group, member objects

## [Contract](./Contract)

+ Get contract, member group, member object

## [Device](./Device)

+ Get, set, remove device
+ Get device extension, member groups, member object, member of, transitive member of, registered owner, registered user

## [Device Management](./DeviceManagement)
+ ### [Devices](./DeviceManagement/Devices)
+ ### [Policies](./DeviceManagement/Policies)

## [Domain](./Domain)

+ New, confirm, get, set, remove domain
+ Invoke force delete domain
+ Get domain name reference

## [Groups](./Groups)

+ Get group
+ Get group member, get member count
+ Get group transitive member, get transitive member count
+ Get group member of, get member of count
+ Get group member with license error, get member with license error count
+ Get, get count group extension
+ Get group conversation, conversation count
+ Get group conversation thread, thread count
+ Get all group sites
+ Get accepted sender, accepted sender count
+ Get group thread, thread count
+ Get thread post, thread post count
+ Get group delta, member group, member object
+ Get group Lifecycle Policy, policy count
+ Get, remove photo
+ Get, set photo content
+ Get group setting

+ New, set, restore, remove, invoke renew group
+ New, set, remove group extension
+ New, get group member
+ New, get group owner
+ Get members with license error
+ New, get, set, remove group lifecycle policy
+ Add, remove group to/from lifecycle policy
+ Get rejected group sender
+ Get group permission grant
+ Get group Lifecycle Policy
+ Get group notebook
+ Get group conversation thread, conversation thread post
+ Test group property
+ Reset group unseen count

## [Mail](./Mail)

+ New, get, set, remove user mail folder
+ New, get, set, remove user mail folder child folder
+ New, get, set, remove user message
+ New, get, set, remove user mail folder message
+ New, get, set, remove user mail folder child folder message
+ Get user mail folder message attachment, rule
+ Get user mail folder child folder message attachment
+ Get user message attachment
+ Get user message content
+ Get, remove user inference classification 

## [Organization](./Organization)

+ Get organization
+ Get organization extension, member object

## [Others](./Others)

+ Get, remove subscribed Skus

## [Teams](./Teams)

+ New, get, set, copy, remove, archive, unarchive team
+ New, get, set, remove team channel
+ Get, set, remove team channel tab
+ Get team incoming channels 
+ Get, remove team member
+ Get, set, remove team of group
+ Get team app
+ Get team app definition
+ Get team operation
+ Get, remove team channel file folder
+ Get team work
+ Get user team joined team
+ Get user team work
+ Get user team work associated team
+ Get team group operation
+ New, get, set, remove group team channel
+ Get, remove user team work installed app
+ Get team photo
+ Get, set team photo content
+ Get user chat

## [Users](./Users)

+ New, get, set, remove user
+ Get, set user photo content
+ Get, set, remove user manager
+ Get user photo
+ Get user count
+ Get, set user setting
+ Get, set, new, remove user extension
+ Get user sponsor
+ Get, set user mailbox settings
+ Get user member of, member of count
+ Get direct report, direct report count
+ Get, set, remove license detail
+ Get, new, set, remove, count Outlook master categories
+ Get owned object. As group, as application, count
+ Get owned device. As device, count
+ Get registered device. As device, count
+ Get created object
+ Get group memberships
+ Get OAuth permission grant
+ Get, new, set, remove todo list
+ Get, new, set, remove todo list extension
+ Get, new, set, remove todo list task
+ Get, set, new, remove, count, content task attachment
+ Get, new, set, remove task check list item
+ Get, new, set, remove todo list task linked resource
+ Revoke user sessions

## [Library](./_LIB_)

+ Connect/disconnect Azure Tenant